package com.lwtek.demo;

import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.CompoundButton;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;

import com.lwtek.demo.databinding.ActivityParamBinding;
import com.lwtek.scanner.core.ScannerDevice;

public class ParamActivity extends AppCompatActivity implements View.OnClickListener, AdapterView.OnItemSelectedListener, CompoundButton.OnCheckedChangeListener {

    private ActivityParamBinding binding;

    private int volume;
    private int speed;
    private boolean vibration;
    private int caseTransform;
    private int endSymbol;

    private int sleepTime;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityParamBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        initView();
        getInfo();
    }

    public void initView() {
        setSupportActionBar(binding.appbar);

        binding.save.setOnClickListener(this);

        binding.volume.setOnItemSelectedListener(this);
        binding.speed.setOnItemSelectedListener(this);
        binding.vibration.setOnCheckedChangeListener(this);
        binding.caseTransform.setOnItemSelectedListener(this);
        binding.endSymbol.setOnItemSelectedListener(this);
        binding.sleepTime.setOnItemSelectedListener(this);
    }

    public void getInfo() {
        MyApplication.getDevice().getVolume((data, error) ->
                runOnUiThread(() -> {
                    if (data != null) binding.volume.setSelection(data.ordinal());
                })
        );
        MyApplication.getDevice().getSpeed((data, error) ->
                runOnUiThread(() -> {
                    if (data != null) binding.speed.setSelection(data.ordinal());
                })
        );
        MyApplication.getDevice().getVibration((data, error) -> {
            if (data != null) {
                vibration = data;
                runOnUiThread(() -> {
                    binding.vibration.setChecked(vibration);
                });
            }
        });
        MyApplication.getDevice().getCase((data, error) ->
                runOnUiThread(() -> {
                    if (data != null) binding.caseTransform.setSelection(data.ordinal());
                })
        );
        MyApplication.getDevice().getEndSymbol((data, error) ->
                runOnUiThread(() -> {
                    if (data != null) binding.endSymbol.setSelection(data.ordinal());
                })
        );
        MyApplication.getDevice().getSleepTime((data, error) ->
                runOnUiThread(() -> {
                    if (data != null) binding.sleepTime.setSelection(data.ordinal());
                })
        );
    }

    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == binding.save.getId()) {
            MyApplication.getDevice().setVolume(ScannerDevice.Volume.values()[volume]);
            MyApplication.getDevice().setSpeed(ScannerDevice.Speed.values()[speed]);
            MyApplication.getDevice().setVibration(vibration);
            MyApplication.getDevice().setCase(ScannerDevice.Case.values()[caseTransform]);
            MyApplication.getDevice().setEndSymbol(ScannerDevice.EndSymbol.values()[endSymbol]);
            MyApplication.getDevice().setSleepTime(ScannerDevice.SleepTime.values()[sleepTime]);
        }
    }

    @Override
    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
        int vid = parent.getId();
        if (vid == binding.volume.getId()) {
            volume = position;
        } else if (vid == binding.speed.getId()) {
            speed = position;
        } else if (vid == binding.caseTransform.getId()) {
            caseTransform = position;
        } else if (vid == binding.endSymbol.getId()) {
            endSymbol = position;
        } else if (vid == binding.sleepTime.getId()) {
            sleepTime = position;
        }
    }

    @Override
    public void onNothingSelected(AdapterView<?> parent) {

    }

    @Override
    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        int vid = buttonView.getId();
        if (vid == binding.vibration.getId()) {
            vibration = isChecked;
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.param_menu, menu);
        return super.onCreateOptionsMenu(menu);
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        if (item.getItemId() == R.id.refresh) {
            getInfo();
        }
        return super.onOptionsItemSelected(item);
    }
}